<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\DB;
use App\Models\CategoryTranslation;


class Post extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'posts';

    /**
     * @var mixed
     */
    protected $revisionEnabled = true;

    /**
     * @var mixed
     */
    protected $revisionCleanup = true;

    /**
     * @var int
     */
    protected $historyLimit = 20;

    /**
     * @var array
     */
    protected $dontKeepRevisionOf = [
        'content',
        'views',
    ];

    /**
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'slug',
        'subtitle',
        'description',
        'content',
        'image',
        'video',
        'is_featured',
        'format_type',
        'status',
        'publish_date',
        'publish_time',
        'top_story',
        'popular_story',
        'time_zone',
        'author_id',
        'author_type',
        'aetos_id',
        'date_line',
        'photos',
        'videos',
        'logos',
        'is_slider',
        'is_breaknews',
    ];

    /**
     * @return BelongsToMany
     */
    public function tags(): BelongsToMany
    {
        return $this->belongsToMany(Tag::class, 'post_tags');
    }

/**
 * @return BelongsToMany
 */
/**
 * @return BelongsToMany
 */
    public function ctasTemp(): BelongsToMany
    {
        return $this->belongsToMany(Category::class, 'post_categories');
    }

    /**
     * @return BelongsToMany
     */
    public function categories(): BelongsToMany
    {
        return $this->belongsToMany(Category::class, 'post_categories');
    }

    /**
     * @return BelongsToMany
     */
    public function circuit()
{
    // return $this->belongsToMany(Circuits::class, 'post_circuit');
}

        /**
     * @return BelongsToMany
     */
    public static function paginateCat($catid, $page, $rowperpage, $lang_code, $website_id)
{
    $posts = DB::table('posts')->where('lang', $lang_code)
        ->join('post_categories', 'post_categories.post_id', '=', 'posts.id')
        ->where('websites', 'LIKE', '%,'.$website_id.',%')
        ->where('post_categories.category_id', $catid)
        ->Orderby('posts.created_at', 'DESC')
        ->offset(($page - 1) * $rowperpage)
        ->limit($rowperpage)->get();
    return $posts;
}

    /**
     * @return BelongsToMany
     */
    public static function paginateTag($tagid, $page, $rowperpage, $lang_code, $website_id)
{
    $posts = DB::table('posts')->where('lang', $lang_code)
        ->join('post_tags', 'post_tags.post_id', '=', 'posts.id')
        ->join('post_website', 'post_website.post_id', '=', 'posts.id')
        ->where('websites', 'LIKE', '%,'.$website_id.',%')
        ->where('post_tags.tag_id', $tagid)
        ->Orderby('posts.created_at', 'DESC')
        ->offset(($page - 1) * $rowperpage)
        ->limit($rowperpage)->get();

    return $posts;
}

    /**
     * @return BelongsToMany
     */
    public static function paginateSearch($search_term, $website_id, $page, $rowperpage, $lang_code)
{
    $query = DB::table('posts')->select(['posts.*'])->where('lang', $lang_code)//->select('posts.*')
        ->where('websites', 'LIKE', '%,'.$website_id.',%')
        ->where('posts.name', 'like', '%' . $search_term . '%')
        ->orWhere('posts.content', 'like', '"%' . $search_term . '%"')
        ->orWhere('posts.description', 'like', '%' . $search_term . '%')
        ->groupBy('id');
        $query->Orderby('posts.created_at', 'DESC');//

        $query->offset(($page-1 )* $rowperpage);
        $posts = $query->limit($rowperpage)->get();

        // $posts['data'] = $posts;
    return $posts;
}


    /**
     * @return BelongsToMany
     */
public static function getWebsiteLatest($lang_code, $website_id, $cat_id = '', $limit = 6, $is_breaknews = '', $toArray = 1,$images_query=0)
{
    $query = Post::select(['posts.*'])->where('lang', $lang_code)
        ->where('websites', 'LIKE', '%,'.$website_id.',%');

    if ($cat_id != '') {
         $query->where('cats', 'LIKE', '%,'.$cat_id.',%');
        // $query->join('post_categories', 'post_categories.post_id', '=', 'posts.id')
        //     ->where('post_categories.category_id', $cat_id);
    }
    if ($images_query==1) {
        $query->whereNotNull('image');
        $query->where('image','!=',"0");
        $query->where('image','!=',"");
    }elseif($images_query==2){
        $query->whereNull('image');
        $query->where('image','==',"0");
        $query->where('image','==',"");
    }
    if ($is_breaknews != '') {
        $query->where('is_breaknews', 1);
    }

    if ($limit) {
        $query->limit($limit);
    }

    $query->Orderby('posts.created_at', 'DESC');

    if ($toArray==1)
        $posts = $query->get()->toArray();
    else
        $posts = $query->get();//->toArray();


    return $posts;
}

public static function getSliderLatestArticles($lang_code, $website_id, $limit = 6, $is_top_news=0,$is_slider=0,$toArray = 1,$images_query=0)
{

    $query = Post::select(['posts.id','posts.name','posts.subtitle','posts.image','posts.content','posts.slug','posts.created_at'])->where('lang', $lang_code)
        ->where('websites', 'LIKE', '%,'.$website_id.',%');



     if ($images_query==1) {
        $query->whereNotNull('posts.image');
        $query->where('posts.image','!=',"0");
        $query->where('posts.image','!=',"");
    }elseif($images_query==2){
        $query->whereNull('posts.image');
        $query->where('posts.image','==',"0");
        $query->where('posts.image','==',"");
    }
    if ($limit) {
        $query->limit($limit);
    }

    if ($is_slider != 0) {
        $query->where('is_slider', 1);
    }
    $query->Orderby('posts.created_at', 'DESC');

    // if ($toArray==1)
    //     $posts = $query->get()->toArray();
    // else
        $posts = $query->get();//->toArray();

    foreach ($posts as $post) {
        $postCategories = $post->ctasTemp;
        if ($lang_code != 'en_US') {
            foreach ($postCategories as $cat) {
                if(isset($cat)){
                    $item = CategoryTranslation::where('categories_id', $cat->id)->where('lang_code', $lang_code)->first();
                    $item->slug = $cat->slug;
                    $arCategoris[] = $item;
                }else{
                    $arCategoris[] = [];
                }
            }
            $post->cats = $arCategoris;
        }else{
            $post->cats = $postCategories;
        }
    }

    return $posts;
}
}
