<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Request;

class MenuNode extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'menu_nodes';

    /**
     * @var array
     */
    protected $fillable = [
        'menu_id',
        'parent_id',
        'reference_id',
        'reference_type',
        'url',
        'icon_font',
        'title',
        'css_class',
        'target',
        'has_child',
        'position',
    ];

    /**
     * @return BelongsTo
     */
    public function parent()
    {
        return $this->belongsTo(MenuNode::class, 'parent_id');
    }

    /**
     * @return HasMany
     */
    public function child()
    {
        return $this->hasMany(MenuNode::class, 'parent_id')->orderBy('position');
    }

    /**
     * @return mixed
     * @deprecated
     */
    public function hasChild()
    {
        return $this->has_child;
    }

    /**
     * @return $this
     * @deprecated
     */
    public function getRelated()
    {
        return $this;
    }

    /**
     * @return mixed
     * @deprecated
     */
    public function getNameAttribute()
    {
        return $this->title;
    }

}
