<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Menu extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'menus';

    /**
     * @var array
     */
    protected $fillable = [
        'name',
        'slug',
        'status',
    ];

    /**
     * @return HasMany
     */
    public function menuNodes(): HasMany
    {
        return $this->hasMany(MenuNode::class, 'menu_id')->select(['title', 'url', 'has_child', 'parent_id', 'menu_id', 'id', 'reference_type', 'css_class'])->orderBy('position');
        // return $this->hasMany(MenuNode::class, 'menu_id');
    }

    /**
     * @return HasMany
     */
    public function locations(): HasMany
    {
        return $this->hasMany(MenuLocation::class, 'menu_id');
    }

}
