<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\DB;
use App\Models\Language;

class Website extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'websites';

    /**
     * @var array
     */
    protected $fillable = [
        'website',
        'ip',
        'domain',
        'zone',
        'timezone',
        'email',
        'rss_url_ar',
        'rss_url_en',
        'rss_feed_count',
        'template',
        'key',
        'languages',
        'logo',
        'light_logo',
        'favicon',
        'about',
        'phone',
        'instagram',
        'facebook',
        'twitter',
        'primary_color',
        'secondary_color',
        'content',
        'header',
        'footer',
        'status',
        'header_color',
        'footer_color',
        'font',
        'paragraph_color',
        'custom_css',
        'inner_page_style',
        'show_search',
        'show_top_categories',
        'show_top_tags',
        'show_top_posts',
        'show_image',
        'columns_count',
        'header_menu',
        'footer_menu',
        'secondary_menu',
        'seo_title',
        'seo_descripion',
        'listing_style',
        'title_position',
        'inner_pages_banner',
        'banner_image',
        'about_theme',
        'contact_theme',
        'about_text',
        'about_image',
        'contact_text',
        'googletag_script',
        'tag_script',
        'banner_250_250',
        'banner_300_250',
        'banner_300_600',
        'banner_728_90',
        'banner_728_90_footer',
        'google_analytics',
        'websites',
    ];


    /**
     * @return BelongsToMany
     */
    public function circuit()
    {
        return $this->belongsToMany(Circuits::class, 'website_circuit');
    }

    /**
     * @return BelongsToMany
     */
    public function languages()
    {
        return $this->belongsToMany(Language::class, 'website_languages');
    }

    /**
     * @return BelongsToMany
     */
    public function getLanguages()
    {
        $selected_languages = [];
        $temp_lang = DB::table('website_languages')->where(['website_id' => $this->getModel()->id])->get() ;
        foreach($temp_lang as $item){
            $lang = Language::where('lang_id', $item->language_lang_id)->select('lang_locale','lang_flag','lang_code','lang_name')->first();
            $selected_languages[] = $lang;
        }
        return $selected_languages;
    }

}
