<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->get('menu', [
    'as' => 'menu', 'uses' => 'WebsiteController@menu'
]);

$router->get('social', [
    'as' => 'social', 'uses' => 'WebsiteController@social'
]);

$router->get('settings', [
    'as' => 'settings', 'uses' => 'WebsiteController@settings'
]);

$router->get('website', [
    'as' => 'website', 'uses' => 'WebsiteController@website'
]);

$router->get('posts', [
    'as' => 'posts', 'uses' => 'WebsiteController@posts'
]);

$router->get('recent_posts', [
    'as' => 'recent_posts', 'uses' => 'WebsiteController@recent_posts'
]);

$router->get('Category_by_name', [
    'as' => 'Category_by_name', 'uses' => 'WebsiteController@Category_by_name'
]);

$router->get('Category_by_slug', [
    'as' => 'Category_by_slug', 'uses' => 'WebsiteController@Category_by_slug'
]);

$router->get('Tag_by_slug', [
    'as' => 'Tag_by_slug', 'uses' => 'WebsiteController@Tag_by_slug'
]);

$router->get('Search', [
    'as' => 'Search', 'uses' => 'WebsiteController@Search'
]);

$router->get('Category_by_id', [
    'as' => 'Category_by_id', 'uses' => 'WebsiteController@Category_by_id'
]);

$router->get('threeCategoryData', [
    'as' => 'threeCategoryData', 'uses' => 'WebsiteController@threeCategoryData'
]);

$router->get('twoCategoryData', [
    'as' => 'twoCategoryData', 'uses' => 'WebsiteController@twoCategoryData'
]);
$router->get('fourCategoryData', [
    'as' => 'fourCategoryData', 'uses' => 'WebsiteController@fourCategoryData'
]);
$router->get('popularTags', [
    'as' => 'popularTags', 'uses' => 'WebsiteController@popularTags'
]);

$router->get('popularCategories', [
    'as' => 'popularCategories', 'uses' => 'WebsiteController@popularCategories'
]);

$router->get('relatedPosts', [
    'as' => 'relatedPosts', 'uses' => 'WebsiteController@relatedPosts'
]);

$router->get('recentPosts', [
    'as' => 'recentPosts', 'uses' => 'WebsiteController@recentPosts'
]);

$router->get('post', [
    'as' => 'post', 'uses' => 'WebsiteController@post'
]);
$router->get('post-lang', [
    'as' => 'post-lang', 'uses' => 'WebsiteController@postLang'
]);

$router->get('breaking-news', [
    'as' => 'breaking-news', 'uses' => 'WebsiteController@getBreakingNews'
]);
$router->get('get-categories-with-data', [
    'as' => 'categories-with-data', 'uses' => 'WebsiteController@getCategorieswithData'
]);
$router->get('slider-news', [
    'as' => 'slider-news', 'uses' => 'WebsiteController@getSliderNews'
]);

$router->get('top-news', [
    'as' => 'slider-news', 'uses' => 'WebsiteController@getTopNews'
]);

$router->post('contact', [
    'as' => 'contact', 'uses' => 'WebsiteController@contact'
]);
