<?php

namespace App\Http\Controllers;

use App\Models\BaseStatusEnum;
use Illuminate\Http\Request;
use App\Models\Menu;
use App\Models\Website;
use App\Models\WebsiteTranslation;
use App\Models\CategoryTranslation;
use App\Models\TagTranslation;
use App\Models\Post;
use App\Models\archived_posts;
use App\Models\Category;
use App\Models\Tag;
use App\Models\Contact;
use App\Models\PostWebsite;
use UnexpectedValueException;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

class WebsiteController extends Controller
{

    public function __construct()
    {
    }

    public function menu(Request $request)
    {
        $website_name = $request->input('website');
        $lang_code = $request->input('lang_code');

        // Get All Menus Of this website Header, Footer, Secondary Menu
        // get website id
        $website = Website::where('website', $website_name)->first();

        // if language no english get language menu
        if ($lang_code != 'en_US') {
            $temp = WebsiteTranslation::where('websites_id', $website->id)->where('lang_code', $lang_code)->first();
            $website->header_menu = $temp->header_menu;
            $website->footer_menu = $temp->footer_menu;
            $website->secondary_menu = $temp->secondary_menu;
        }

        // get all items of menu and then get there child's recursevly
        $header_menu = Menu::where('id', $website->header_menu)->where('lang_code', $lang_code)->first();
        $top_header_menu = Menu::where('id', $website->secondary_menu)->where('lang_code', $lang_code)->first();
        $footer_menu = Menu::where('id', $website->footer_menu)->where('lang_code', $lang_code)->first();

        if (isset($header_menu)) {
            $header_menu = $header_menu ? $header_menu->menuNodes : null;
            foreach ($header_menu as $key => $node) {
                if ($node->hasChild()) {
                    $node['child'] = $this->getNodeChildRecursevly($node);
                }
                if ($node->parent_id !== 0) {
                    unset($header_menu[$key]);
                }
            }
            // $header_menu_array =  [];
            // foreach ($header_menu as $key => $node) {
            //     $header_menu_array[] = $node;
            // }
        }

        if (isset($top_header_menu)) {
            $top_header_menu = $top_header_menu ? $top_header_menu->menuNodes : null;
            foreach ($top_header_menu as $key => $node) {
                if ($node->hasChild()) {
                    $node['child'] = $this->getNodeChildRecursevly($node);
                }
                if ($node->parent_id !== 0) {
                    unset($top_header_menu[$key]);
                }
            }
        }

        if (isset($footer_menu)) {
            $footer_menu = $footer_menu ? $footer_menu->menuNodes : null;
            foreach ($footer_menu as $key => $node) {
                if ($node->hasChild()) {
                    $node['child'] = $this->getNodeChildRecursevly($node);
                }
                if ($node->parent_id !== 0) {
                    unset($footer_menu[$key]);
                }
            }
        }

        return response()->json([
            'data' => [
                // 'mainMenu' => $header_menu,
                // 'top_header_menu' => $top_header_menu,
                // 'footerMenu' => $footer_menu,
                'mainMenu' => $this->fixMenu($header_menu , 'header'),
                'top_header_menu' => $this->fixMenu($top_header_menu , 'footer'),
                'footerMenu' => $this->fixMenu($footer_menu, 'top header'),
                'message' => 'Message',
            ]
        ], 200);

    }

    function fixMenu($menu , $place){
        foreach($menu as $item){
            if( strcmp($item->url, "Botble\Blog\Models\Category")  || strcmp($item->url, "Botble\Blog\Models\Tag")){
                $result = preg_split("#/#", $item->url);
                if($result[1] == "ar" || $result[1] == "fr"){
                    $url = '';
                    foreach($result as $key => $item1){
                        if ($key > 1)
                            $url =  $url.'/'.$item1;
                    }
                    $item->url = $url;
                }
            }
        }

        // dd($place);
        // dd($menu);
        return $menu;
    }

    function getNodeChildRecursevly($node)
    {
        $childItems = [];
        $childNodes = $node->child;
        foreach ($childNodes as $childNode) {
            if ($node->hasChild()) {
                $childItems['child'] = $this->getNodeChildRecursevly($childNode);
            } else {
                $childItems[] = $childNode;
            }
        }

        $nodes['child'] = $childItems;
    }

    function settings(Request $request)
    {
        $website_name = $request->input('website');
        $lang_code = $request->input('lang_code');

        $settings = Website::where('website', $website_name)->first();
        $languages = (array) $settings->getLanguages();
        if ($lang_code != 'en_US') {
            $temp = WebsiteTranslation::where('websites_id', $settings->id)->where('lang_code', $lang_code)->first();
            $settings->name = $temp->name;
            $settings->about = $temp->about;
            $settings->font = $temp->font;
            $settings->seo_title = $temp->seo_title;
            $settings->seo_descripion = $temp->seo_descripion;
            $settings->about_text = $temp->about_text;
            $settings->contact_text = $temp->contact_text;
        }
        $settings->logo = env('CNP_URL') . '/storage/' . $settings->logo;
        $settings->light_logo = env('CNP_URL') . '/storage/' . $settings->light_logo;
        $settings->storageUrl = env('CNP_URL') . '/storage/';
        $settings->BaseUrl = env('APP_URL');
        return response()->json([
            'data' => [
                'settings' => $settings,
                'languages' => $languages,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    public function parseReadData($data): array
    {
        $results = [];

        foreach ($data as $row) {
            if (is_array($row)) {
                $key = $row['key'];
                $value = $row['value'];
            } elseif (is_object($row)) {
                $key = $row->key;
                $value = $row->value;
            } else {
                $msg = 'Expected array or object, got ' . gettype($row);
                throw new UnexpectedValueException($msg);
            }

            Arr::set($results, $key, $value);
        }

        return $results;
    }

    function website(Request $request)
    {
        $website_name = $request->input('website');
        $lang_code = $request->input('lang_code');

        $website = Website::where('website', $website_name)->first();

        // if ($lang_code != 'en_US') {
        //     $website = WebsiteTranslation::where('websites_id', $website->id)->where('lang_code', $lang_code)->first();
        // }

        preg_match_all("/\\[(.*?)\\]/", $website->content, $matches);
        $elements = [];
        foreach ($matches[1] as $key => $item) {

            $re = '/(\w+)\=\"([a-zA-Z0-9 ,.\/&%?=]+)\"/m';
            preg_match_all($re, $item, $matches);
            $c = array_combine($matches[1], $matches[2]);

            $element_with_att = explode(" ", $item);

            $object = (object) [
                'component' => $element_with_att[0],
                'attributes' => (array) $c,
                '_uid' => Str::uuid()->toString(),
            ];
            if ($key % 2 == 0) {
                $elements[] = $object;
            }
        }

        $header = json_decode(json_encode($elements[0]), true);
        $lastElement = count($elements);
        $footer = json_decode(json_encode($elements[$lastElement - 1]), true);

        $website->header = $header;
        $website->footer = $footer;
        $website->save();

        return response()->json([
            'data' => [
                'elements' => $elements,
                'message' => 'Message',
            ]
        ], 200);
    }

    function posts(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $website_id = $request->input('website_id');
        $posts = Post::getWebsiteLatest($lang_code, $website_id);
        return response()->json([
            'data' => $posts
        ], 200);
    }

    function recent_posts(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $website_id = $request->input('website_id');

        if($website_id){
            $posts = Post::getWebsiteLatest($lang_code, $website_id,0,3,0,1,1);
            return response()->json([
                'data' => $posts
            ], 200);
        }else{
            return response()->json([
                'data' => []
            ], 200);
        }
    }

    function threeCategoryData(Request $request)
    {
        $images_query=($request->has('images_query')) ? $request->input('images_query') : 0;
        $limit = $request->has('limit') ? $request->input('limit') : 5;
        $cat1 = $request->input('cat1');
        $cat2 = $request->input('cat2');
        $cat3 = $request->input('cat3');

        $lang_code = $request->input('lang_code');
        $website_id = $request->input('website_id');

        $category1 = Category::where('id', $cat1)->first();
        $category2 = Category::where('id', $cat2)->first();
        $category3 = Category::where('id', $cat3)->first();

        if ($lang_code != 'en_US') {
            $tcategory1 = isset($category1) ? CategoryTranslation::where('categories_id', $category1->id)->where('lang_code', $lang_code)->first() : [];
            $tcategory2 = isset($category2) ? CategoryTranslation::where('categories_id', $category2->id)->where('lang_code', $lang_code)->first() : [];
            $tcategory3 = isset($category3) ? CategoryTranslation::where('categories_id', $category3->id)->where('lang_code', $lang_code)->first() : [];


            $posts1 = isset($category1) ? Post::getWebsiteLatest($lang_code, $website_id, $category1->id, $limit, '',1,$images_query) :  [];
            $posts2 = isset($category2) ? Post::getWebsiteLatest($lang_code, $website_id, $category2->id, $limit, '',1,$images_query) :  [];
            $posts3 = isset($category3) ? Post::getWebsiteLatest($lang_code, $website_id, $category3->id, $limit, '',1,$images_query) :  [];

            $cat1name = isset($tcategory1) && $tcategory1 != [] ? $tcategory1->name :  [];
            $cat2name = isset($tcategory2) && $tcategory2 != [] ? $tcategory2->name :  [];
            $cat3name = isset($tcategory3) && $tcategory3 != [] ? $tcategory3->name :  [];

            $posts1 = array_values($posts1);
            $posts2 = array_values($posts2);
            $posts3 = array_values($posts3);
        } else {
            $posts1 = isset($category1) ? Post::getWebsiteLatest($lang_code, $website_id, $category1->id, $limit, '',1,$images_query) :  [];
            $posts2 = isset($category2) ? Post::getWebsiteLatest($lang_code, $website_id, $category2->id, $limit, '',1,$images_query) :  [];
            $posts3 = isset($category3) ? Post::getWebsiteLatest($lang_code, $website_id, $category3->id, $limit, '',1,$images_query) :  [];

            $posts1 = array_values($posts1);
            $posts2 = array_values($posts2);
            $posts3 = array_values($posts3);

            $cat1name = isset($category1) ? $category1->name : [];
            $cat2name = isset($category2) ? $category2->name : [];
            $cat3name = isset($category3) ? $category3->name : [];
        }


        return response()->json([
            'data' => [
                'cat1' => $posts1,
                'cat1name' => $cat1name,
                'cat2' => $posts2,
                'cat2name' => $cat2name,
                'cat3' => $posts3,
                'cat3name' => $cat3name,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function getCategorieswithData(Request $request)
    {
        $limit = $request->has('limit') ? $request->input('limit') : 5;
        $categories = [];
        $lang_code = $request->input('lang_code');
        $categoriesList = Category::where('status', 'published')->get();

        foreach ($categoriesList as $category) {
            if ($lang_code != 'en_US') {
                $tcategory = isset($category) ? CategoryTranslation::where('categories_id', $category->id)->where('lang_code', $lang_code)->first() : [];
                $posts = isset($category) ? $category->posts->take($limit)->where('lang', $lang_code)->toArray() : [];
                $categories[strtolower(str_replace(" ", "-", $category->slug))] = ['category' => $tcategory, 'posts' => $posts];
            } else {
                $posts =  $category->posts->take($limit)->where('lang', $lang_code);
                $categories[strtolower(str_replace(" ", "-", $category->slug))] = ['category' => $category, 'posts' => $posts];
            }
        }

        return response()->json([
            'data' => [
                'categories' => $categories,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function twoCategoryData(Request $request)
    {
        $images_query=($request->has('images_query')) ? $request->input('images_query') : 0;
        $limit = $request->has('limit') ? $request->input('limit') : 5;
        $cat1 = $request->input('cat1');
        $cat2 = $request->input('cat2');

        $lang_code = $request->input('lang_code');
        $website_id = $request->input('website_id');

        $category1 = Category::where('id', $cat1)->first();
        $category2 = Category::where('id', $cat2)->first();

        if ($lang_code != 'en_US') {
            $tcategory1 = isset($category1) ? CategoryTranslation::where('categories_id', $category1->id)->where('lang_code', $lang_code)->first() : [];
            $tcategory2 = isset($category2) ? CategoryTranslation::where('categories_id', $category2->id)->where('lang_code', $lang_code)->first() : [];


            $posts1 = isset($category1) ? Post::getWebsiteLatest($lang_code, $website_id, $category1->id, $limit, '',1,$images_query) :  [];
            $posts2 = isset($category2) ? Post::getWebsiteLatest($lang_code, $website_id, $category2->id, $limit, '',1,$images_query) :  [];

            $cat1name = isset($tcategory1) && $tcategory1 != [] ? $tcategory1->name :  [];
            $cat2name = isset($tcategory2) && $tcategory2 != [] ? $tcategory2->name :  [];

            $posts1 = array_values($posts1);
            $posts2 = array_values($posts2);
        } else {
            $posts1 = isset($category1) ? Post::getWebsiteLatest($lang_code, $website_id, $category1->id, $limit, '',1,$images_query) :  [];
            $posts2 = isset($category2) ? Post::getWebsiteLatest($lang_code, $website_id, $category2->id, $limit, '',1,$images_query) :  [];

            $posts1 = array_values($posts1);
            $posts2 = array_values($posts2);

            $cat1name = isset($category1) ? $category1->name : [];
            $cat2name = isset($category2) ? $category2->name : [];
        }


        return response()->json([
            'data' => [
                'cat1' => $posts1,
                'cat1name' => $cat1name,
                'cat2' => $posts2,
                'cat2name' => $cat2name,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function fourCategoryData(Request $request)
    {
        $limit = $request->has('limit') ? $request->input('limit') : 5;
        $cat1 = $request->input('cat1');
        $cat2 = $request->input('cat2');
        $cat3 = $request->input('cat3');
        $cat4 = $request->input('cat4');
        $lang_code = $request->input('lang_code');
        $website_id = $request->input('website_id');

        $category1 = Category::where('id', $cat1)->first();
        $category2 = Category::where('id', $cat2)->first();
        $category3 = Category::where('id', $cat3)->first();
        $category4 = Category::where('id', $cat4)->first();

        if ($lang_code != 'en_US') {
            $tcategory1 = isset($category1) ? CategoryTranslation::where('categories_id', $category1->id)->where('lang_code', $lang_code)->first() : [];
            $tcategory2 = isset($category2) ? CategoryTranslation::where('categories_id', $category2->id)->where('lang_code', $lang_code)->first() : [];
            $tcategory3 = isset($category3) ? CategoryTranslation::where('categories_id', $category3->id)->where('lang_code', $lang_code)->first() : [];
            $tcategory4 = isset($category4) ? CategoryTranslation::where('categories_id', $category4->id)->where('lang_code', $lang_code)->first() : [];

            $posts1 = isset($category1) ? Post::getWebsiteLatest($lang_code, $website_id, $category1->id, $limit, '') :  [];
            $posts2 = isset($category2) ? Post::getWebsiteLatest($lang_code, $website_id, $category2->id, $limit, '') :  [];
            $posts3 = isset($category3) ? Post::getWebsiteLatest($lang_code, $website_id, $category3->id, $limit, '') : [];
            $posts4 = isset($category4) ? Post::getWebsiteLatest($lang_code, $website_id, $category4->id, $limit, '') :  [];
            $cat1name = isset($tcategory1) && $tcategory1 != [] ? $tcategory1->name :  [];
            $cat2name = isset($tcategory2) && $tcategory2 != [] ? $tcategory2->name :  [];
            $cat3name = isset($tcategory3) && $tcategory3 != [] ? $tcategory3->name :  [];
            $cat4name = isset($tcategory4) && $tcategory4 != [] ? $tcategory4->name :  [];

            $posts1 = array_values($posts1);
            $posts2 = array_values($posts2);
            $posts3 = array_values($posts3);
            $posts4 = array_values($posts4);
        } else {


            $posts1 = isset($category1) ? Post::getWebsiteLatest($lang_code, $website_id, $category1->id, $limit, '') :  [];
            $posts2 = isset($category2) ? Post::getWebsiteLatest($lang_code, $website_id, $category2->id, $limit, '') :  [];
            $posts3 = isset($category3) ? Post::getWebsiteLatest($lang_code, $website_id, $category3->id, $limit, '') : [];
            $posts4 = isset($category4) ? Post::getWebsiteLatest($lang_code, $website_id, $category4->id, $limit, '') :  [];
            $cat1name = isset($category1) ? $category1->name : [];
            $cat2name = isset($category2) ? $category2->name : [];
            $cat3name = isset($category3) ? $category3->name : [];
            $cat4name = isset($category4) ? $category4->name : [];

            $posts1 = array_values($posts1);
            $posts2 = array_values($posts2);
            $posts3 = array_values($posts3);
            $posts4 = array_values($posts4);
        }

        return response()->json([
            'data' => [
                'cat1' => $posts1,
                'cat1name' => $cat1name,
                'cat2' => $posts2,
                'cat2name' => $cat2name,
                'cat3' => $posts3,
                'cat3name' => $cat3name,
                'cat4' => $posts4,
                'cat4name' => $cat4name,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function getTopNews(Request $request)
    {
        $images_query=($request->has('images_query')) ? $request->input('images_query') : 0;
        $limit = ($request->has('limit')) ? $request->input('limit') : 8;
        $lang_code = ($request->has('lang_code')) ? $request->input('lang_code') : 'en_US';
        $website_id = $request->input('website_id');

        $posts = Post::getSliderLatestArticles($lang_code, $website_id,  $limit,1,0,0,$images_query);

        return response()->json([
            'data' => [
                'posts' => $posts,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function getBreakingNews(Request $request)
    {
        $limit = ($request->has('limit')) ? $request->input('limit') : 4;
        $lang_code = ($request->has('lang_code')) ? $request->input('lang_code') : 'en_US';
        $website_id = $request->input('website_id');
        $is_breaknews = 1;

        $posts = Post::getWebsiteLatest($lang_code, $website_id, '', $limit, $is_breaknews);

        return response()->json([
            'data' => [
                'posts' => $posts,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function getSliderNews(Request $request)
    {
        $limit = ($request->has('limit')) ? $request->input('limit') : 4;
        $lang_code = ($request->has('lang_code')) ? $request->input('lang_code') : 'en_US';
        $website_id = $request->input('website_id');
        $images_query=($request->has('images_query')) ? $request->input('images_query') : 0;

        $posts = Post::getSliderLatestArticles($lang_code, $website_id,  $limit,0,1,1,$images_query);

        return response()->json([
            'data' => [
                'posts' => $posts,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function popularTags(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $popularTags = Tag::get();

        if ($lang_code != 'en_US') {
            $tags = [];
            foreach ($popularTags as $tag) {
                $tag = isset($tag) ? TagTranslation::where('tags_id', $tag->id)->where('lang_code', $lang_code)->first() : [];
            }
            return response()->json([
                'data' => [
                    'popularTags' => $tags,
                    'message' => 'Settings Retrived Successfully.',
                ]
            ], 200);
        }

        return response()->json([
            'data' => [
                'popularTags' => $popularTags,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function popularCategories(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $popularCategories = Category::get();

        if ($lang_code != 'en_US') {
            $categoris = [];
            foreach ($popularCategories as $cat) {
                if(isset($cat)){
                    $item = CategoryTranslation::where('categories_id', $cat->id)->where('lang_code', $lang_code)->first();
                    $item->slug = $cat->slug;
                    $categoris[] = $item;
                }else{
                    $categoris[] = [];
                }
            }
            return response()->json([
                'data' => [
                    'popularCategories' => $categoris,
                    'message' => 'Settings Retrived Successfully.',
                ]
            ], 200);
        }


        return response()->json([
            'data' => [
                'popularCategories' => $popularCategories,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function relatedPosts(Request $request)
    {
        $limit = $request->input('limit');
        $lang_code = $request->input('lang_code');
        $website_id = $request->input('website_id');

        $relatedPosts = Post::getWebsiteLatest($lang_code, $website_id, '', $limit, '');

        return response()->json([
            'data' => [
                'relatedPosts' => $relatedPosts,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function recentPosts(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $limit = $request->input('limit');
        $website_id = $request->input('website_id');
        $images_query=($request->has('images_query')) ? $request->input('images_query') : 1;
        $recentPosts = Post::getWebsiteLatest($lang_code, $website_id, '', $limit, '',1,$images_query);

        return response()->json([
            'data' => [
                'recentPosts' => $recentPosts,
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function post(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $slug = $request->input('slug');
        $website_id = $request->input('website_id');
        $langSwitch = $request->input('langSwitch');

        $post = Post::where('slug', $slug)->first();

        if($langSwitch == 'true'){
            $post = Post::where('base_id', $post->base_id)->where('lang', $lang_code)->first();
        }

        $relatedPosts = Post::getWebsiteLatest($lang_code, $website_id, '', 4, '');
        if(!$post){
            $tmp_post = Post::where('slug', $slug)->first();
            if(!$tmp_post){
                $this->archivedPost($request);
            }else{
                $post = Post::where('base_id', $tmp_post->base_id)->where('lang', $lang_code)->first();
            }
        }

        if($post){
            $postCategories = $post->categories;
            if ($lang_code != 'en_US') {
                foreach ($postCategories as $cat) {
                    if(isset($cat)){
                        $item = CategoryTranslation::where('categories_id', $cat->id)->where('lang_code', $lang_code)->first();
                        $item->slug = $cat->slug;
                        $categoris[] = $item;
                    }else{
                        $categoris[] = [];
                    }
                }
                $postCategories = $categoris;
            }

            return response()->json([
                'data' => [
                    'post' => $post,
                    'relatedPosts' => $relatedPosts,
                    'categories' => $postCategories,
                    'message' => 'Settings Retrived Successfully.',
                ]
            ], 200);

        }else{
            $this->archivedPost($request);
        }
    }

    // function postLang(Request $request)
    // {
    //     $slug = $request->input('slug');
    //     $post = Post::where('slug', $slug)->first();

    //     return response()->json([
    //         'data' => [
    //             'lang' => $post->lang,
    //             'message' => 'Settings Retrived Successfully.',
    //         ]
    //     ], 200);

    // }

    function archivedPost(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $slug = $request->input('slug');
        $website_id = $request->input('website_id');
        $post = archived_posts::where('slug', $slug)->where('lang', $lang_code)->first();
        $relatedPosts = Post::getWebsiteLatest($lang_code, $website_id, '', 4, '');
        if(!$post){
            $tmp_post = archived_posts::where('slug', $slug)->first();
            if($tmp_post)
                $post = archived_posts::where('base_id', $tmp_post->base_id)->where('lang', $lang_code)->first();
        }

        if($post){
            $postCategories = $post->categories;
            if ($lang_code != 'en_US') {
                foreach ($postCategories as $cat) {
                    if(isset($cat)){
                        $item = CategoryTranslation::where('categories_id', $cat->id)->where('lang_code', $lang_code)->first();
                        $item->slug = $cat->slug;
                        $categoris[] = $item;
                    }else{
                        $categoris[] = [];
                    }
                }
                $postCategories = $categoris;
            }

            return response()->json([
                'data' => [
                    'post' => $post,
                    'relatedPosts' => $relatedPosts,
                    'categories' => $postCategories,
                    'message' => 'Settings Retrived Successfully.',
                ]
            ], 200);

        }else{
            return response()->json([
                'data' => 'empty'
            ], 200);
        }
    }

    function Search(Request $request)
    {
        $lang_code = $request->input('lang_code');
        $search_term = $request->input('search_term');
        $website_id = $request->input('website_id');
        $page = $request->input('page');
        $rowperpage = $request->input('rowperpage');

        $posts = Post::paginateSearch($search_term, $website_id, $page, $rowperpage, $lang_code);

        return response()->json([
            'data' => [
                'posts' => ['data' => $posts],
                'category' => [],
                'tag' => [],
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);

    }

    function Category_by_slug(Request $request)
    {
        $slug = $request->input('slug');
        $page = $request->input('page');
        $website_id = $request->input('website_id');
        $rowperpage = $request->input('rowperpage');
        $lang_code = $request->input('lang_code');

        $category = Category::where('slug', $slug)->first();

        if (isset($category)) {
            $posts = Post::paginateCat($category->id, $page, $rowperpage, $lang_code, $website_id);

            return response()->json([
                'data' => [
                    'posts' => ['data' => $posts],
                    'category' => $category,
                    'message' => 'Settings Retrived Successfully.',
                ]
            ], 200);
        } else {
            return response()->json([
                'data' => [
                    'posts' => [],
                    'category' => '',
                    'message' => 'Not data',
                ]
            ], 200);
        }
    }

    function Tag_by_slug(Request $request)
    {
        $slug = $request->input('slug');
        $page = $request->input('page');
        $website_id = $request->input('website_id');
        $rowperpage = $request->input('rowperpage');
        $lang_code = $request->input('lang_code');

        $tag = Tag::where('slug', $slug)->first();

        if (isset($tag)) {
            $posts = Post::paginateCat($tag->id, $page, $rowperpage, $lang_code, $website_id);

            return response()->json([
                'data' => [
                    'posts' => ['data' => $posts],
                    'tag' => $tag,
                    'category' => [],
                    'message' => 'Settings Retrived Successfully.',
                ]
            ], 200);
        } else {
            return response()->json([
                'data' => [
                    'posts' => [],
                    'category' => [],
                    'tag' => [],
                    'message' => 'Not data',
                ]
            ], 200);
        }
    }

    function Category_by_id(Request $request)
    {
        $category_id = $request->input('category_id');
        $lang_code = $request->input('lang_code');

        $category = Category::where('id', $category_id)->first();

        if ($lang_code != 'en_US') {
            $category = CategoryTranslation::where('categories_id', $category->id)->where('lang_code', $lang_code)->first();
        }

        $posts = $category->posts;

        return response()->json([
            'data' => [
                'posts' => ['data' => $posts],
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);
    }

    function Contact(Request $request)
    {
        $lang_code = $request->input('lang_code');

        // if($request->input('name') == '' || $request->input('email') == ''){
        //     return response()->json([
        //         'data' => [
        //             'message' => 'Please Fill All Fields',
        //         ]
        //     ], 500);
        // }elseif(!preg_match_all("/(?![[:alnum:]]|@|-|_|\.)./",$request->input('email'))){
        //     return response()->json([
        //         'data' => [
        //             'message' => 'Please Enter a valid email',
        //         ]
        //     ], 500);
        // }

        $model = new Contact;

            $model->fill([
                'email' => $request->input('email'),
                'name' => $request->input('name'),
                'content' => $request->input('message'),
                'phone' => $request->input('phone'),
                'subject' => $request->input('subject'),
            ]);

        $model->save();


        return response()->json([
            'data' => [
                'message' => 'Settings Retrived Successfully.',
            ]
        ], 200);

    }

}
